*-----------------------------------------------------------------------
      program test02

      parameter (nlat=6,nlon=3)

      integer   lat(nlat),lon(nlon),ist(2),icn(2)
      real      wind(nlat,nlon)
      character cdsn*80,cttl1*80,cttl2*80,cttl3*80

      data      ist / 1, 1 /, icn / nlat, nlon /

      data      cdsn/'test01.nc'/


*     / open netcdf file /

      call nxopen(ncdfid,cdsn,'r')

*     / inquire dimension size /

      call nxdqsz(ncdfid,'nlat',ilat)
      write(6,*) ' nlat = ',ilat
      call nxdqsz(ncdfid,'nlon',ilon)
      write(6,*) ' nlon = ',ilon

*     / get attributes /

      call nxagtx(ncdfid,':date',idate)
      write(6,*) ' :date = ',idate
      call nxagtc(ncdfid,':comment',cttl1)
      write(6,*) ' :comment = ',cttl1(1:lenc(cttl1))
      call nxagtx(ncdfid,'lat:grid',lat)
      write(6,*) ' lat:grid = ',lat
      call nxagtc(ncdfid,'lat:unit',cttl2)
      write(6,*) ' lat:unit = ',cttl2(1:lenc(cttl2))
      call nxagtx(ncdfid,'lon:grid',lon)
      write(6,*) ' lon:grid = ',lon
      call nxagtc(ncdfid,'lon:unit',cttl3)
      write(6,*) ' lon:unit = ',cttl3(1:lenc(cttl3))

*     / read data /

      call nxvgax(ncdfid,'flag',iflag)
      write(6,*) ' flag = ',iflag
      call nxvgax(ncdfid,'lat',lat)
      write(6,*) ' lat = ',lat
      call nxvgax(ncdfid,'lon',lon)
      write(6,*) ' lon = ',lon
      call nxvgax(ncdfid,'wind',wind)
      write(6,*) ' wind = ',wind

*     / close netcdf file /

      call nxclos(ncdfid)

      end
