*-----------------------------------------------------------------------
      program test04

      parameter (nlat=6,nlon=3)

      integer   lat(nlat),lon(nlon),ist(3),icn(3)
      real      wind(nlat,nlon)
      character cdsn*80

      data      lat /  10,  20,  30,  40,  50,  60 /
      data      lon /  20,  40,  60 /
      data      wind/ 0.1, 0.2, 0.3, 0.4, 0.5, 0.4,
     +                0.2, 0.3, 0.3, 0.4, 0.6, 0.5,
     +                0.1, 0.3, 0.3, 0.3, 0.5, 0.4 /

      data      ist / 1, 1, 2 /, icn / nlat, nlon, 1 /

      data      cdsn/'test04.nc'/


*     / open netcdf file /

      call nxopen(ncdfid,cdsn,'c')

*     / define dimensions /

      call nxddef(ncdfid,'nlat',nlat)
      call nxddef(ncdfid,'nlon',nlon)
      call nxddef(ncdfid,'time',0)

*     / define variables /

      call nxvdef(ncdfid,'flag','i')
      call nxvdef(ncdfid,'lat(nlat)','i')
      call nxvdef(ncdfid,'lon(nlon)','i')
      call nxvdef(ncdfid,'wind(nlat,nlon,time)','r')

*     / put attributes /

      call nxaptx(ncdfid,':date','i',1,19930129)
      call nxaptx(ncdfid,':imiss','i',1,-999)
      call nxaptx(ncdfid,':rmiss','r',1,-999.0)
      call nxaptx(ncdfid,':dmiss','d',1,-999.0D1)
      call nxaptc(ncdfid,':comment','c',14,'test wind data')
      call nxaptx(ncdfid,'lat:grid','i',nlat,lat)
      call nxaptc(ncdfid,'lat:unit','c',6,'degree')
      call nxaptx(ncdfid,'lon:grid','i',nlon,lon)
      call nxaptc(ncdfid,'lon:unit','c',6,'degree')
      call nxaptx(ncdfid,'wind:_FillValue','r',1,-999.0)

*     / leave define mode /

      call nxdefm(ncdfid,.false.)

*     / write data /

      call nxvpnx(ncdfid,'flag',1,1,1)
      call nxvpnx(ncdfid,'lat',ist(1),icn(1),lat)
      call nxvpnx(ncdfid,'lon',ist(2),icn(2),lon)
      call nxvpnx(ncdfid,'wind',ist,icn,wind)

*     / close netcdf file /

      call nxclos(ncdfid)

      end
