*-----------------------------------------------------------------------
      program test06

      parameter (nlat=6,nlon=3,nmon=12,nchr=3)

      integer   ist(3),icn(3),idx(3)
      real      rlat(nlat),rlon(nlon)
      double precision wind(nlat,nlon)
      character cdsn*80,cmn(nmon)*(nchr),cmon*(nchr)

      data      rlat /  10,  20,  30,  40,  50,  60 /
      data      rlon /  20,  40,  60 /
      data      wind/ 0.1d0, 0.2d0, 0.3d0, 0.4d0, 0.5d0, 0.4d0,
     +                0.2d0, 0.3d0, 0.3d0, 0.4d0, 0.6d0, 0.5d0,
     +                0.1d0, 0.3d0, 0.3d0, 0.3d0, 0.5d0, 0.4d0 /

      data      ist / 1, 1, 2 /, icn / nlat, nlon, 1 /

      data      cdsn/'test06.nc'/


*     / initialize /

      do n=1,nmon
        cmn(n)=cmon(n)
      end do

*     / open netcdf file /

      call nxopen(ncdfid,cdsn,'c')

*     / define dimensions /

      call nxddef(ncdfid,'nlat',nlat)
      call nxddef(ncdfid,'nlon',nlon)
      call nxddef(ncdfid,'nmon',nmon)
      call nxddef(ncdfid,'nchr',nchr)

*     / define variables /

      call nxvdef(ncdfid,'flag','i')
      call nxvdef(ncdfid,'lat(nlat)','r')
      call nxvdef(ncdfid,'lon(nlon)','r')
      call nxvdef(ncdfid,'mon(nchr,nmon)','c')
      call nxvdef(ncdfid,'wind(nlat,nlon,nmon)','d')

*     / put attributes /

      call nxaptx(ncdfid,':date','i',1,19930129)
      call nxaptc(ncdfid,':comment','c',14,'test wind data')
      call nxaptx(ncdfid,'lat:grid','r',nlat,rlat)
      call nxaptc(ncdfid,'lat:unit','c',6,'degree')
      call nxaptx(ncdfid,'lon:grid','r',nlon,rlon)
      call nxaptc(ncdfid,'lon:unit','c',6,'degree')
      call nxaptx(ncdfid,'wind:_FillValue','d',1,-999.0)

*     / leave define mode /

      call nxdefm(ncdfid,.false.)

*     / write data /

      call nxvp1x(ncdfid,'flag',0,1)
      call nxvpnx(ncdfid,'lat',ist(1),icn(1),rlat)
      call nxvpnx(ncdfid,'lon',ist(2),icn(2),rlon)
      do n=1,nmon
        ist(1)=1
        ist(2)=n
        icn(1)=nchr
        icn(2)=1
        call nxvpnc(ncdfid,'mon',ist,icn,cmn(n))
      end do
      do n=1,nmon,2
        call clower(cmn(n))
        do m=1,nchr
          idx(1)=m
          idx(2)=n
          call nxvp1c(ncdfid,'mon',idx,cmn(n)(m:m))
        end do
      end do
      do k=2,nmon,2
        do j=1,nlon
          do i=1,nlat
            idx(1)=i
            idx(2)=j
            idx(3)=k
            call nxvp1x(ncdfid,'wind',idx,wind(i,j)*k)
          end do
        end do
      end do

*     / close netcdf file /

      call nxclos(ncdfid)

      end
